# INPUT:  A string in {a, b}*.
# OUTPUT: Whether the string has no copies of aa or bb
#
# Checks if the input string has no copies of the substrings aa and bb.
# Equivalently, checks if the characters alternate between a and b.
# We use two labels to track what the last-seen character is.

Start:
    If Blank Return True
    If 'a' Goto LastA
    If 'b' Goto LastB
    Return False # Unknown character?

LastA:
    Move Right
    If Blank Return True
    If 'a' Return False   # Two consecutive a's
    If 'b' Goto LastB
    Return False # Unknown character?

LastB:
    Move Right
    If Blank Return True
    If 'b' Return False   # Two consecutive b's
    If 'a' Goto LastA
    Return False # Unknown character?
